
#include <stdio.h>
#include <string.h>
#include <Node.h>
#include <File.h>
#include <StorageDefs.h>
#include <Message.h>
#include <fs_attr.h>
#include <ByteOrder.h>

enum schenum
{
	ENUM_0,
	ENUM_EOF,
	ENUM_ERR
} ;

static
enum schenum
fetch_node (
	BFile *input,
	BNode *node,
	char *path,
	uint8 *pathlenP
)
{
	enum schenum rval = ENUM_0;

// read pathlen
	if(input->Read(pathlenP, 1) <= 0)
		rval = ENUM_EOF;

// read path
	else if(input->Read(path, *pathlenP) != *pathlenP)
		rval = ENUM_EOF;

// path -> BNode
	else if(path[*pathlenP] = 0, node->SetTo (path) != B_OK)
	{
		fprintf(stderr, "path [%s] not found\n", path);
		rval = ENUM_ERR;
	}

	return rval;
}

static
int
get_flatsz (
	BFile *input,
	uint32 *szP
)
{
	int rval = 0;
	uint32 bend;

	if(input->Read(&bend, 4) != 4)
		rval = 1;
	else
		*szP = B_BENDIAN_TO_HOST_INT32(bend);

	return rval;
}

static
int
add_attrs (
	BFile *input,
	BNode *node
)
{
	int rval = 0;
	uint32 msz;
	BMessage msg;

// get message size
	if(get_flatsz(input, &msz))
		rval = 1;

// unflatten the message
	else if (msg.Unflatten(input) != B_OK)
		rval = 1;

// message data -> attributes
	else
	{
		int32 i=0;
		char *name;
		uint32 type;
		int32 count;
		status_t post = B_OK;

		while(
			post == B_OK &&
			(post = msg.GetInfo(B_ANY_TYPE, i, &name, &type, &count)) == B_OK
		)
		{
		void *data;
		ssize_t nbyte;
			if( (post = msg.FindData(name, type, 0, &data, &nbyte)) != B_OK)
				fprintf(stderr, "FindData Error : %x\n", post);
			else
			// should error check !!
				node->WriteAttr(name, type, 0, data, nbyte);

			i++;
		}
	}

	return rval;
}

static
int
skip_msg(BFile *input)
{
	int rval = 0;
	uint32 msz;

// get message size
	if(get_flatsz(input, &msz))
		rval = 1;

// skip over it
	else if(input->Seek(msz, SEEK_CUR) == B_ERROR)
		rval = 1;

	return rval;
}

int
main (
	int argc,
	char **argv
)
{
	status_t post = B_OK;
	BFile input[1] ;

	if(argc < 2)
		fprintf(stderr, "Usage: %s input-file\n", argv[0]);
	else if(input->SetTo(argv[1], B_READ_ONLY)!=B_OK)
		fprintf(stderr, "Error opening [%s] for reading\n", argv[1]);
	else
	{
		enum schenum denum = ENUM_0;
		char path[B_PATH_NAME_LENGTH];
		uint8 pathlen;
		BNode node[1];

		while(
			denum != ENUM_EOF &&
			(denum = fetch_node(input, node, path, &pathlen)) != ENUM_EOF
		)
		{
			if(denum == ENUM_0)
			{
				if(add_attrs(input, node) != 0)
				{
				fprintf(stderr, "add_attrs failue\n");
					denum = ENUM_ERR;
				}
			}
			else
			{
				if(skip_msg(input) != 0)
				{
				fprintf(stderr, "skip_msg failue\n");
					denum = ENUM_EOF;
				}
			}
		}
	}

	return 0;
}

